import {Command} from 'commander';

import getAverageScoreAndMetrics from '../../getAverageScoreAndMetrics';

const program = new Command();

program
    .option('-u, --url <string>', 'url to measure')
    .option('-i, --iterations <string>', 'runs count');

program.parse(process.argv);

const options: {
    iterations: string;
    url: string;
} = program.opts();

(async (): Promise<void> => {
    const scoreAndMetrics = await getAverageScoreAndMetrics({
        url: options.url,
        iterations: Number(options.iterations),
        withLogs: true,
    });

    process.send?.(scoreAndMetrics);
})();
