import times from 'lodash/times';

import {ILighthouseScoreAndMetrics} from '../../types';

import measurePages from './measurePages';

export type TPagesMetrics = Record<string, ILighthouseScoreAndMetrics>;

export default async function getPagesMetrics(
    pages: Record<string, string>,
    concurrentMeasures: number,
    measuresPerPage: number,
): Promise<TPagesMetrics> {
    const pagesMetrics: TPagesMetrics = {};
    const pagesLeft = [...Object.entries(pages)];

    await Promise.all(
        times(concurrentMeasures, () =>
            measurePages(
                {
                    iterations: measuresPerPage,
                },
                pagesMetrics,
                pagesLeft,
            ),
        ),
    );

    return pagesMetrics;
}
