import {ILighthouseCalculateOptions} from '../../types';

import getPageMetrics from './getPageMetrics/getPageMetrics';
import {TPagesMetrics} from './getPagesMetrics';

export default async function measurePages(
    options: Pick<ILighthouseCalculateOptions, 'iterations'>,
    pagesMetrics: TPagesMetrics,
    pagesLeft: [string, string][],
): Promise<void> {
    const pageInfo = pagesLeft.pop();

    if (!pageInfo) {
        return;
    }

    const [id, url] = pageInfo;

    pagesMetrics[id] = await getPageMetrics({
        url,
        iterations: options.iterations,
    });

    if (pagesLeft.length) {
        await measurePages(options, pagesMetrics, pagesLeft);
    }
}
