#!/usr/bin/env bash
set -e

MAJOR_VERSION=$(node -e "process.stdout.write(require('./package.json').version.split('.')[0])")

npm version "$MAJOR_VERSION.$MINOR_VERSION.$PATCH_VERSION"

npm config set //npm.yandex-team.ru/:_authToken=$NPM_AUTH_TOKEN
npm config set //npm.yandex-team.ru/:username=robot-ya-travel
npm config set //npm.yandex-team.ru/:email=robot-ya-travel@yandex-team.ru
npm config set //npm.yandex-team.ru/:always-auth=false

npm set unsafe-perm true

npm ci
npm publish --cache="/tmp/npm_cache_$(date +"%s")" --verbose --registry=https://npm.yandex-team.ru/
