interface IErrorReason {
    message: string;
    stack: string;
}

export interface IHermioneSingleTestReport {
    suitePath: string[];
    fullName: string;
    browserId: string;
    file: string;
    duration: number | null;
    status: 'success' | 'fail' | 'skipped';
    meta?: Record<string, unknown>;
    errorReason?: IErrorReason;
    retries?: IErrorReason[];
    skipReason?: string;
    url?: string;
}

export type THermioneTestsReport = Record<string, IHermioneSingleTestReport>;
