#!/usr/bin/env bash

set -e

function saveResultResources(){
    cp -R ./html-report/report "$RESULT_RESOURCES_PATH/html-report"

    cp ./json-report/report.json "$RESULT_RESOURCES_PATH/json-report.json"

    if [ -d "./reports" ]; then
      cp -R ./reports "$RESULT_RESOURCES_PATH/reports"
    fi
}

function notifyStartrek() {
    if [ "$STARTREK_TICKET_ID" ]; then
        export JSON_REPORT_PATH="$PWD/json-report/report.json"

        # shellcheck source=/dev/null
        source "$ARCADIA_PATH/$TRAVEL_CI_PATH/registry/portal/e2e/e2e-st-notify/e2e-st-notify.sh"
    fi
}

function addTestcopResource() {
    mkdir "testcop";

    echo "<meta http-equiv='refresh' content='0;URL=https://testcop.si.yandex-team.ru/task/$SANDBOX_TASK_ID'>"  >& "testcop/index.html"

    cp -R ./testcop "$RESULT_RESOURCES_PATH/testcop"
}

npm ci

if npm run test:e2e; then
    saveResultResources
    addTestcopResource
    notifyStartrek

    echo 'success' > "$RESULT_RESOURCES_PATH/status"

    exit 0
else
    saveResultResources
    addTestcopResource
    notifyStartrek

    echo 'error' > "$RESULT_RESOURCES_PATH/status"

    exit 1
fi


