import StartrekService from 'src/services/startrek/startrek';

import {Logger} from 'src/utilities/logger';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

(async function () {
    const logger = new Logger('SKIP_E2E_IN_RELEASE');

    try {
        const ticket = getEnvVariable(EEnvironmentVariables.STARTREK_TICKET_ID);
        const startrekToken = getEnvVariable(
            EEnvironmentVariables.STARTREK_TOKEN,
        );

        const STClient = new StartrekService({
            oauth: startrekToken,
        });

        const message = '⚠️В релизе были пропущены e2e тесты⚠️';

        await Promise.all([
            STClient.appendComment({
                ticket,
                text: message,
            }),
            STClient.patchIssue({
                ticket,
                fields: {tags: {add: ['e2e_tests_skipped']}},
            }),
        ]);

        logger.success('ok');
    } catch (error) {
        if (error instanceof Error) {
            logger.log(error.message);
        }
    }
})();
