import StartrekService from 'src/services/startrek/startrek';

import {Logger} from 'src/utilities/logger';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';
import {changePullRequestCITable} from 'src/helpers/arcanum.helpers';
import parseMultilineString from 'src/utilities/parseMultilineString';

(async function () {
    const logger = new Logger('STAND_NOTIFY');

    try {
        const ticket = getEnvVariable(
            EEnvironmentVariables.STARTREK_TICKET_ID,
            '',
        );
        const pullRequestId = getEnvVariable(
            EEnvironmentVariables.PULL_REQUEST_ID,
        );
        const appVersion = getEnvVariable(EEnvironmentVariables.APP_VERSION);
        const standUrls = parseMultilineString(
            getEnvVariable(EEnvironmentVariables.STAND_URL),
        );
        const crowdtestBalancerStand = getEnvVariable(
            EEnvironmentVariables.CROWDTEST_STAND_URL,
            '',
        );

        if (ticket) {
            const token = getEnvVariable(EEnvironmentVariables.STARTREK_TOKEN);

            const message = getMessage({appVersion, standUrls});

            const STClient = new StartrekService({
                oauth: token,
            });

            const messages = await STClient.getTicketCommentsList({ticket});

            if (!messages.includes(message)) {
                try {
                    await STClient.appendComment({ticket, text: message});

                    await STClient.patchIssue({
                        ticket,
                        fields: {
                            standUri: standUrls,
                            ...(crowdtestBalancerStand
                                ? {crowdtestBalancerStand}
                                : {}),
                        },
                    });
                } catch (e) {
                    logger.logError(e as Error);
                }
            }
        }

        if (pullRequestId) {
            await changePullRequestCITable(
                pullRequestId,
                standUrls.map((url, index) => ({
                    key: `Stand url ${index}`,
                    value: url,
                })),
            );
        }

        logger.success('ok');
    } catch (error) {
        if (error instanceof Error) {
            logger.logError(error);
        }
    }
})();

interface IGetMessageParams {
    appVersion: string;
    standUrls: string[];
}

function getMessage({appVersion, standUrls}: IGetMessageParams): string {
    if (standUrls.length === 1) {
        return `Образ %%${appVersion}%% выложен на ((${standUrls[0]} стенд))`;
    }

    return [
        `Образ %%${appVersion}%% выложен на стенд:`,
        ...standUrls.map(url => `* ${url}`),
    ].join('\n');
}
