import StartrekService from 'src/services/startrek/startrek';

import {Logger} from 'src/utilities/logger';
import {setStFields} from './utilities/setStFields';
import {setReleaseChecklist} from './utilities/setReleaseChecklist';
import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

(async function () {
    const logger = new Logger('UPDATE_RELEASE_TICKET');

    try {
        const ticket = getEnvVariable(EEnvironmentVariables.STARTREK_TICKET_ID);
        const startrekToken = getEnvVariable(
            EEnvironmentVariables.STARTREK_TOKEN,
        );
        const flowLink = getEnvVariable(EEnvironmentVariables.CI_FLOW_LINK);
        const appVersion = getEnvVariable(EEnvironmentVariables.APP_VERSION);

        const STClient = new StartrekService({
            oauth: startrekToken,
        });

        await setStFields(STClient, {ticket, flowLink, appVersion});
        await setReleaseChecklist(STClient, {ticket});
    } catch (error) {
        if (error instanceof Error) {
            logger.log(error.message);
        }
    } finally {
        logger.success('ok');
    }
})();
