import StartrekService from 'src/services/startrek/startrek';

import {EStartrekIssueLinkType} from 'src/types/startrek';

import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';
import parseMultilineString from 'src/utilities/parseMultilineString';

export async function setReleaseChecklist(
    STClient: StartrekService,
    {ticket}: {ticket?: string},
) {
    if (!ticket) {
        return;
    }

    const links = await STClient.getIssueLinks({ticket});
    const prevListItems = await STClient.getChecklistItems({ticket});
    const prevListItemsState: Record<string, boolean> = prevListItems.reduce(
        (res, item) => ({
            [item.text]: item.checked,
            ...res,
        }),
        {},
    );

    const staticChecklist = parseMultilineString(
        getEnvVariable(EEnvironmentVariables.STARTREK_CHECKLIST, ''),
    );

    const queues = parseMultilineString(
        getEnvVariable(EEnvironmentVariables.STARTREK_QUEUE),
    );
    const queuesRegExp = queues.map(queue => new RegExp(queue));

    const nextListItems = [
        ...links
            .filter(
                ({object, type}) =>
                    queuesRegExp.some(queueRegExp =>
                        queueRegExp.test(object.key || ''),
                    ) && type.id === EStartrekIssueLinkType.RELATES,
            )
            .map(({object}) => `${object.key}: ${object.display}`),
        ...staticChecklist,
    ].map(text => ({
        text,
        checked: Boolean(prevListItemsState[text]),
    }));

    if (prevListItems.length) {
        await STClient.removeChecklistItems({ticket});
    }

    await STClient.addChecklistItems({ticket, items: nextListItems});
}
