import {IExecOptions} from 'src/types/process';

import {isArcCommand, isArcError} from 'src/utilities/arc';
import {Process} from 'src/utilities/process';

export async function execArc(command: string, options?: IExecOptions) {
    const cmd = new Process();
    const arcCommand = isArcCommand(command) ? command : `arc ${command}`;

    return await cmd.exec(arcCommand, {...options, isError: isArcError});
}

export async function getArcInfo(options?: IExecOptions) {
    const response = await execArc(`arc info --json`, options);

    return JSON.parse(response.stdout) || {};
}
