export type TFarmContext = {
    project: string;
    organization: string;
    pullRequestId: string;
    pullRequestSummary?: string;
    pollTimeout: string;
    featureBranch: string;
    upstreamBranch: string;
    farmUrl: string;
    standKey: string;
    crowdtestUrl: string;
    storybookUrl: string;
    ciTableKey: string;
    messagePrefixString: string;
    [other: string]: string | undefined;
};

export enum EInstanceStatus {
    QUEUED = 'queued',
    GENERATING = 'generating',
    RUNNING = 'running',
}

export interface IGetInstanceResponse {
    instance: {
        processName: string;
        instanceName: string;
        project: string;
        branch: string;
        organization: string;
        urlTemplate: string | null;
        status: EInstanceStatus;
        createdAt: string;
        launchedAt: string;
        folder: string | null;
        name: string | null;
        envVariables: Record<string, string>;
    };
    url: string;
}
