export interface IConstructorArg {
    host?: string;
    oauth: string;
}
export interface ITicketInfo {
    summary: string;
    description: string;
    queue: string;
    parent?: string;
    assignee?: string;
    components?: string[];
    tags?: string[];
    links?: {
        relationship:
            | 'relates'
            | 'is dependent by'
            | 'depends on'
            | 'is subtask for'
            | 'is parent task for'
            | 'duplicates'
            | 'is duplicated by'
            | 'is epic of'
            | 'has epic'
            | 'original'
            | 'clone';
        issue: string;
    }[];
}

enum EIssueLinkDirection {
    INWARD = 'INWARD',
    OUTWARD = 'OUTWARD',
}

enum EStLocales {
    RU = 'ru',
    EN = 'en',
}

type TIssueLocalizedValue = Record<EStLocales, string>;

interface IBaseIssueStructure {
    self: string;
    id: string;
    version?: number;
    key?: string;
    display: string | TIssueLocalizedValue;
}

export interface IIssueLink {
    self: string;
    id: number;
    type: {
        self: string;
        id: string;
        inward: string | TIssueLocalizedValue;
        outward: string | TIssueLocalizedValue;
    };
    direction: EIssueLinkDirection;
    object: IBaseIssueStructure;
    createdBy: IBaseIssueStructure;
    updatedBy: IBaseIssueStructure;
    createdAt: string;
    updatedAt: string;
    assignee?: IBaseIssueStructure;
    status: IBaseIssueStructure;
}

enum EIssueChecklistDeadlineType {
    QUARTER = 'QUARTER',
    DATE = 'DATE',
}

enum EIssueChecklistItemType {
    STANDARD = 'STANDARD',
    METRIC = 'METRIC',
    CRITERION = 'CRITERION',
    FILTER = 'FILTER',
}

export interface IIssueChecklistItem {
    text: string;
    checked: boolean;
    assignee?:
        | string
        | number
        | {
              uid: number;
              passportUid: number;
              login: string;
              id: string;
              cloudUid: string;
              trackerUid: number;
          };
    deadline?: {
        date: string;
        deadlineType: EIssueChecklistDeadlineType;
        isExceeded: boolean;
    };
    url?: string;
    checklistItemType?: EIssueChecklistItemType;
}

export interface IStoredIssueChecklistItem {
    id: string;
    checked: boolean;
    checklistItemType: EIssueChecklistItemType;
    text: string;
    textHtml: string;
}

export interface ICommentsResponse {
    data: ICommentInfo[];
}

export interface ICommentInfo {
    id: string;
    text: string;
}

export interface IIssueBaseParams {
    ticket: string;
}

export interface ICreateCommentParams extends IIssueBaseParams {
    text: string;
}

export interface IStTicket {
    key: string;
}

export interface IPatchIssueParams extends IIssueBaseParams {
    fields: Record<string, string | object>;
}

export interface IAddChecklistParams extends IIssueBaseParams {
    items: IIssueChecklistItem[];
}
