import {ILoggerInterface} from 'src/types/common';
import axios, {AxiosInstance} from 'axios';
import {IConstructorArg} from 'src/services/startrek/types';
import {Logger} from 'src/utilities/logger';
import {
    IThiriumLaunchTestsRequest,
    IThiriumLaunchTestsResponse,
} from 'src/services/thirium/types';

export default class ThiriumService {
    private logger: ILoggerInterface;
    private api: AxiosInstance;

    constructor({host, oauth}: IConstructorArg) {
        this.logger = new Logger('ThiriumService');
        this.api = axios.create({
            baseURL: host || 'https://backend-prod.thirium.yandex-team.ru',
            headers: {
                authorization: `OAuth ${oauth}`,
            },
        });
    }

    async launchTests(
        req: IThiriumLaunchTestsRequest,
    ): Promise<IThiriumLaunchTestsResponse> {
        const url = `/api/v2/launch/`;

        this.logger.log(
            `POST ${this.api.defaults.baseURL} ${url} body: ${JSON.stringify(
                req,
            )}`,
        );

        const res = await this.api.post<IThiriumLaunchTestsResponse>(url, req);

        return res.data;
    }

    async launchStatus(launchId: number): Promise<IThiriumLaunchTestsResponse> {
        const url = `/api/v2/launch/${launchId}`;
        this.logger.log(`GET ${this.api.defaults.baseURL} ${url}}`);

        const res = await this.api.get<IThiriumLaunchTestsResponse>(url);

        return res.data;
    }
}
