export enum ETestCaseStatusDto {
    DRAFT = 'DRAFT',
    TO_CROWD = 'TO_CROWD',
    IN_WORK = 'IN_WORK',
    TO_REVIEW = 'TO_REVIEW',
    IN_REVIEW = 'IN_REVIEW',
    READY = 'READY',
    INVALID = 'INVALID',
}

export enum ETestCaseSnapshotStatusDto {
    DIRTY = 'DIRTY',
    APPROVED = 'APPROVED',
    INVALID = 'INVALID',
}

export enum EActionParamTypeDto {
    CONSTANT = 'CONSTANT',
    SECRET = 'SECRET',
    PROJECT_PARAM = 'PROJECT_PARAM',
    EXPRESSION = 'EXPRESSION',
    ACTION_RESULT = 'ACTION_RESULT',
}

interface ITestActionParamDto {
    optionId: string;
    type?: EActionParamTypeDto;
    value?: string;
}

export enum ELaunchSourceType {
    REGULAR_STABILITY_TEST = 'REGULAR_STABILITY_TEST',
    CREATE_OR_UPDATE_STABILITY_TEST = 'CREATE_OR_UPDATE_STABILITY_TEST',
    REVIEW_STABILITY_TEST = 'REVIEW_STABILITY_TEST',
    DC = 'DC',
    NODE_API_CLIENT = 'NODE_API_CLIENT',
    REGRESS = 'REGRESS',
    UI = 'UI',
    AUTO_FIX_TESTS = 'AUTO_FIX_TESTS',
    THIRIUM_DEV = 'THIRIUM_DEV',
    DOM_SNAPSHOT_COLLECTION = 'DOM_SNAPSHOT_COLLECTION',
}

interface ILaunchSource {
    sourceType: ELaunchSourceType;
    sourceComment: string;
}

type IParams = {
    [optionId: string]: ITestActionParamDto;
};

export interface IThiriumLaunchTestsRequest {
    projects: string[];

    testCaseIds?: string[];

    tags: string[];

    testCaseStatuses: ETestCaseStatusDto[];
    snapshotStatuses: ETestCaseSnapshotStatusDto[];

    params: IParams;

    simultaneousRunsLimit?: number;
    maxRunningTimeSeconds?: number;
    maxTryCount?: number;
    fixedTryCount?: number;

    source?: ILaunchSource;
}

export enum ELaunchStatus {
    NEW = 'NEW',
    RUNNING = 'RUNNING',
    FINISHED = 'FINISHED',
    FAILED = 'FAILED',
}

enum ETestRunStatus {
    NEW = 'NEW',
    RUNNING = 'RUNNING',
    FINISHED = 'FINISHED',
    FAILED = 'FAILED',
    SKIPPED = 'SKIPPED',
}

enum ETestLaunchStatus {
    STARTING = 'STARTING',
    RESTARTING = 'RESTARTING',
    RUNNING = 'RUNNING',
    FINISHED = 'FINISHED',
    FAILED = 'FAILED',
    SKIPPED = 'SKIPPED',
    ABORTED = 'ABORTED',
}

interface ITestAttempts {
    testCaseId: string;
    testCaseVersion: number;
    runId: number;
    status: ETestRunStatus;
    params: IParams;
    outputs: string;
}

interface IThiriumTestCase {
    id: number;
    testCaseId: string;
    testCaseVersion: number;
    attempts: ITestAttempts[];
    testLaunchStatusDto: ETestLaunchStatus;
}

export interface IThiriumLaunchTestsResponse {
    id: number;
    status: ELaunchStatus;
    source: ILaunchSource;
    finishedPercent: number;
    params: IParams;
    testCases: IThiriumTestCase[];
}
