import {ExecException} from 'child_process';
import {AxiosRequestConfig} from 'axios';

export interface ILoggerInterface {
    log(message: string, ...args: unknown[]): void;
    success(message: string, ...args: unknown[]): void;
    error(message: string, ...args: unknown[]): void;
    logError(error?: Error | ExecException | null): void;
    toString(): string;
    setContext(context: string): void;
}

export interface IBadge {
    id: string;
    module: string;
    status: string;
    text: string;
    url: string;
}

export interface IAxiosRequestConfig extends AxiosRequestConfig {
    url: string;
    method?: 'get' | 'post' | 'put' | 'delete';
    baseURL?: string;
    data?: unknown;
    params?: unknown;
    timeout?: number;
    retries?: number;
    logger?: ILoggerInterface;
}

export interface IAxiosResponse<T = unknown> {
    data: T;
    status: number;
    statusText: string;
    headers: unknown;
    config: unknown;
    request?: unknown;
}

export interface IAxiosError<T = unknown> extends Error {
    config: IAxiosRequestConfig;
    code?: string;
    request?: unknown;
    response?: IAxiosResponse<T>;
    isAxiosError: boolean;
    toJSON: () => object;
}
