import {arcanumPullRequestUrlTemplate} from '../constants/common';

export function isArcCommand(command: string) {
    return command.startsWith('arc');
}

export function isArcError(stderr: string) {
    return !/^(WARNING|Already|Switched|HEAD is now at)/m.test(stderr);
}

export function getPrUrl(prId: string) {
    return arcanumPullRequestUrlTemplate.replace('{{id}}', prId);
}

export function parsePrUrl(stdout: string): {url?: string; id?: string} {
    const prUrlPattern = getPrUrl('(\\d+)');
    const [url, id] = stdout.match(new RegExp(prUrlPattern)) || [];

    return {url, id};
}

export function splitBranch(branch: string) {
    const [, prefix = '', , name = ''] =
        branch.match(/^((users|groups|releases)\/[^/]+\/)?(.*)$/) || [];

    return [prefix, name];
}

export function createBranch(input: string | string[]) {
    const chunks = Array.isArray(input) ? input : [input];
    const [prefix, name] = splitBranch(chunks[0]);

    if (prefix) {
        chunks.splice(0, 1, name);
    }

    /** @fixme: remove cutting to maxLength after fix farm urls */
    const maxLength = 63;
    const chunkMaxLength = Math.floor(
        (maxLength - prefix.length) / chunks.length,
    );

    const postfix = chunks
        .filter(Boolean)
        .map(chunk =>
            chunk
                .toLowerCase()
                .replace(/[/@^\s.]/g, '-')
                .replace(/-{2,}/g, '-')
                .replace(/^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$/g, '')
                .substring(0, chunkMaxLength - 1),
        )
        .join('_');

    return `${prefix}${postfix}`.substring(0, maxLength - 1);
}
