import {crowdtestBalancerUrl} from '../constants/common';

import {TFarmContext} from 'src/services/farm/types';

import getEnvVariable, {
    EEnvironmentVariables,
} from 'src/utilities/getEnvVariable';

export function getCrowdtestBalancerFarmUrl(branch: string): string {
    const farmId = branch.replace(/\//g, '_').toLowerCase();

    return `${crowdtestBalancerUrl}/farmId/${farmId}`;
}

export function getStorybookFarmUrl(farmUrl: string): string {
    const url = new URL(farmUrl);

    url.host = `storybook_${url.host}`;

    return url.toString();
}

export function getFarmContext(): TFarmContext {
    const farmUrl = getEnvVariable(EEnvironmentVariables.FARM_URL);
    const project = getEnvVariable(EEnvironmentVariables.FARM_PROJECT);
    const organization = getEnvVariable(
        EEnvironmentVariables.FARM_ORGANIZATION,
    );
    const featureBranch = getEnvVariable(
        EEnvironmentVariables.FARM_FEATURE_BRANCH,
    );
    const upstreamBranch = getEnvVariable(
        EEnvironmentVariables.FARM_UPSTREAM_BRANCH,
    );
    const pollTimeout = getEnvVariable(EEnvironmentVariables.FARM_POLL_TIMEOUT);
    const pullRequestId = getEnvVariable(
        EEnvironmentVariables.FARM_PULL_REQUEST_ID,
    );
    const standKey = getEnvVariable(
        EEnvironmentVariables.FARM_STARTREK_STAND_KEY,
        'standUri',
    );
    const crowdtestUrl = getEnvVariable(
        EEnvironmentVariables.FARM_STARTRECK_FIELD_CROWDTEST_URL,
        '',
    );
    const storybookUrl = getEnvVariable(
        EEnvironmentVariables.FARM_STARTRECK_FIELD_STORYBOOK_URL,
        '',
    );
    const ciTableKey = getEnvVariable(
        EEnvironmentVariables.FARM_PULL_REQUEST_CI_TABLE_KEY,
        'Farm instance',
    );
    const messagePrefixString = getEnvVariable(
        EEnvironmentVariables.FARM_STARTREK_STAND_NOTIFY_MESSAGE_PREFIX,
        'Стенд развернут',
    );

    return {
        farmUrl,
        project,
        organization,
        featureBranch,
        upstreamBranch,
        pullRequestId,
        pollTimeout,
        standKey,
        crowdtestUrl,
        storybookUrl,
        ciTableKey,
        messagePrefixString,
    };
}
