import {PathLike, promises as fs} from 'fs';

type TPackageJsonObject = Record<
    string,
    | string
    | string[]
    | Record<string, string | string[] | Record<string, string>>
>;

export async function readFile(path: PathLike) {
    return (await fs.readFile(path)).toString();
}

export async function readFileJson(path: PathLike) {
    const content = await readFile(path);

    return JSON.parse(content) as TPackageJsonObject;
}

export async function writeToFile(
    path: PathLike,
    content: string,
    flags = 'w',
) {
    let filehandle: fs.FileHandle | undefined;

    try {
        filehandle = await fs.open(path, flags);

        return filehandle.writeFile(content);
    } finally {
        if (filehandle) {
            await filehandle.close();
        }
    }
}

export function appendToFile(path: PathLike, content: string) {
    return writeToFile(path, content, 'a');
}
