export enum EEnvironmentVariables {
    /**
     * COMMON
     */
    APP_VERSION = 'APP_VERSION',
    TRAVEL_CI_PATH = 'TRAVEL_CI_PATH',
    CI_FLOW_LINK = 'CI_FLOW_LINK',
    /**
     * Порядковый номер запуска flow
     */
    VERSION = 'VERSION',
    TRIGGERED_BY = 'TRIGGERED_BY',

    /**
     * PR
     */
    PULL_REQUEST_ID = 'PULL_REQUEST_ID',

    /**
     * STARTREK
     */
    STARTREK_TICKET_ID = 'STARTREK_TICKET_ID',
    STARTREK_TOKEN = 'STARTREK_TOKEN',
    STARTREK_QUEUE = 'STARTREK_QUEUE',
    STARTREK_CHECKLIST = 'STARTREK_CHECKLIST',
    STARTREK_PARENT_TICKET_ID = 'STARTREK_PARENT_TICKET_ID',

    /**
     * BUNDLEMETER
     */
    BUNDLEMETER_COVER_PATH = 'BUNDLEMETER_COVER_PATH',
    BUNDLEMETER_CLICKHOUSE_HOST = 'BUNDLEMETER_CLICKHOUSE_HOST',
    BUNDLEMETER_CLICKHOUSE_PORT = 'BUNDLEMETER_CLICKHOUSE_PORT',
    BUNDLEMETER_CLICKHOUSE_USERNAME = 'BUNDLEMETER_CLICKHOUSE_USERNAME',
    BUNDLEMETER_CLICKHOUSE_PASSWORD = 'BUNDLEMETER_CLICKHOUSE_PASSWORD',

    /**
     * LIGHTHOUSE
     */
    LIGHTHOUSE_CLICKHOUSE_USERNAME = 'LIGHTHOUSE_CLICKHOUSE_USERNAME',
    LIGHTHOUSE_CLICKHOUSE_PASSWORD = 'LIGHTHOUSE_CLICKHOUSE_PASSWORD',
    LIGHTHOUSE_CLICKHOUSE_HOST = 'LIGHTHOUSE_CLICKHOUSE_HOST',
    LIGHTHOUSE_CLICKHOUSE_PORT = 'LIGHTHOUSE_CLICKHOUSE_PORT',
    LIGHTHOUSE_CONFIG_FILE = 'LIGHTHOUSE_CONFIG_FILE',
    LIGHTHOUSE_ITERATIONS_PER_PAGE = 'LIGHTHOUSE_ITERATIONS_PER_PAGE',
    LIGHTHOUSE_CONCURRENT_MEASURES = 'LIGHTHOUSE_CONCURRENT_MEASURES',
    LIGHTHOUSE_PAGE_URLS = 'LIGHTHOUSE_PAGE_URLS',

    /**
     * E2E
     */
    E2E_ENABLE_FILTER_FALLEN_TESTS = 'E2E_ENABLE_FILTER_FALLEN_TESTS',
    E2E_JSON_REPORT_PATH = 'JSON_REPORT_PATH',
    E2E_CLICKHOUSE_USERNAME = 'E2E_CLICKHOUSE_USERNAME',
    E2E_CLICKHOUSE_PASSWORD = 'E2E_CLICKHOUSE_PASSWORD',
    E2E_CLICKHOUSE_HOST = 'E2E_CLICKHOUSE_HOST',
    E2E_CLICKHOUSE_PORT = 'E2E_CLICKHOUSE_PORT',

    /**
     * FARM
     */
    FARM_ORGANIZATION = 'FARM_ORGANIZATION',
    FARM_PROJECT = 'FARM_PROJECT',
    FARM_URL = 'FARM_URL',
    FARM_POLL_TIMEOUT = 'FARM_POLL_TIMEOUT',
    FARM_PULL_REQUEST_ID = 'FARM_PULL_REQUEST_ID',
    FARM_FEATURE_BRANCH = 'FARM_FEATURE_BRANCH',
    FARM_UPSTREAM_BRANCH = 'FARM_UPSTREAM_BRANCH',
    FARM_STARTREK_STAND_KEY = 'FARM_STARTREK_STAND_KEY',
    FARM_STARTRECK_FIELD_CROWDTEST_URL = 'FARM_STARTRECK_FIELD_CROWDTEST_URL',
    FARM_STARTRECK_FIELD_STORYBOOK_URL = 'FARM_STARTRECK_FIELD_STORYBOOK_URL',
    FARM_STARTREK_STAND_NOTIFY_MESSAGE_PREFIX = 'FARM_STARTREK_STAND_NOTIFY_MESSAGE_PREFIX',
    FARM_PULL_REQUEST_CI_TABLE_KEY = 'FARM_PULL_REQUEST_CI_TABLE_KEY',

    /**
     * DEPLOY
     */
    DEPLOY_STAGE_NAME = 'DEPLOY_STAGE_NAME',
    DEPLOY_CONFIG_PATH = 'DEPLOY_CONFIG_PATH',

    /**
     * THIRIUM E2E
     */
    THIRIUM_TOKEN = 'THIRIUM_TOKEN',
    THIRIUM_PRESET = 'THIRIUM_PRESET',
    THIRIUM_TEST_FAILED = 'THIRIUM_TEST_FAILED',

    /**
     * STAND NOTIFY
     */
    STAND_URL = 'STAND_URL',
    CROWDTEST_STAND_URL = 'CROWDTEST_STAND_URL',
}

export default function getEnvVariable(
    variableName: EEnvironmentVariables,
    defaultValue?: string,
): string {
    const value = process.env[variableName];

    if (value) {
        return value;
    }

    if (defaultValue !== undefined) {
        return defaultValue;
    }

    throw new Error(`Environment variable "${variableName}" is not defined`);
}
