const {OFF, WARNING, ERROR} = require('./constants');

module.exports = {
    extends: ['eslint:recommended', 'prettier'],
    parser: '@babel/eslint-parser',
    parserOptions: {
        ecmaVersion: 2019,
        requireConfigFile: false,
    },
    env: {
        es6: true,
        'shared-node-browser': true,
    },
    plugins: ['import-helpers'],
    rules: {
        // Possible Errors
        'no-empty': OFF, // eslint:recommended
        'valid-jsdoc': [
            WARNING,
            {requireParamDescription: false, requireReturnDescription: false},
        ],

        // Best Practices
        'array-callback-return': ERROR,
        'block-scoped-var': WARNING,
        complexity: WARNING,
        'dot-location': [ERROR, 'property'],
        eqeqeq: [WARNING, 'always'],
        'guard-for-in': ERROR,
        'no-caller': ERROR,
        'no-div-regex': WARNING,
        'no-eq-null': ERROR,
        'no-eval': WARNING,
        'no-extend-native': ERROR,
        'no-extra-bind': WARNING,
        'no-extra-label': ERROR,
        'no-floating-decimal': ERROR,
        'no-global-assign': WARNING, // eslint:recommended
        'no-implicit-coercion': WARNING,
        'no-implicit-globals': WARNING,
        'no-implied-eval': WARNING,
        'no-iterator': ERROR,
        'no-labels': ERROR,
        'no-loop-func': ERROR,
        'no-new': ERROR,
        'no-new-func': WARNING,
        'no-new-wrappers': ERROR,
        'no-octal-escape': ERROR,
        'no-param-reassign': WARNING,
        'no-proto': ERROR,
        'no-return-assign': [ERROR, 'always'],
        'no-script-url': ERROR,
        'no-self-compare': ERROR,
        'no-sequences': ERROR,
        'no-throw-literal': WARNING,
        'no-unmodified-loop-condition': ERROR,
        'no-unused-expressions': ERROR,
        'no-useless-call': ERROR,
        'no-useless-concat': ERROR,
        'no-void': ERROR,
        'no-with': ERROR,
        radix: WARNING,
        'wrap-iife': [ERROR, 'inside'],
        'comma-dangle': [WARNING, 'always-multiline'],
        'no-else-return': ERROR,
        'no-mixed-operators': [
            ERROR,
            {
                groups: [['&&', '||']],
            },
        ],

        // Variables
        'no-label-var': ERROR,
        'no-shadow': WARNING,
        'no-shadow-restricted-names': ERROR,
        'no-undef-init': ERROR,
        'no-use-before-define': [WARNING, {functions: false}],

        // Node.js and CommonJS
        'callback-return': WARNING,
        'handle-callback-err': WARNING,
        'no-new-require': ERROR,
        'no-path-concat': WARNING,

        // Stylistic Issues
        camelcase: [WARNING, {properties: 'never'}],
        'comma-style': [ERROR, 'last'],
        'max-depth': [WARNING, {maximum: 5}],
        'new-cap': ERROR,
        'new-parens': ERROR,
        'no-array-constructor': WARNING,
        'no-bitwise': ERROR,
        'no-lonely-if': WARNING,
        'no-negated-condition': WARNING,
        'no-nested-ternary': WARNING,
        'no-new-object': WARNING,
        'no-restricted-syntax': [ERROR, 'WithStatement'],
        'no-unneeded-ternary': ERROR,

        // ECMAStrict 6
        'no-duplicate-imports': ERROR,
        'no-useless-constructor': ERROR,
        'no-var': ERROR,
        'prefer-arrow-callback': [WARNING, {allowNamedFunctions: true}],
        'prefer-const': ERROR,
        'prefer-rest-params': ERROR,
        'prefer-spread': ERROR,
        'require-atomic-updates': OFF, // eslint:recommended
        'require-yield': WARNING, // eslint:recommended

        'padding-line-between-statements': [
            WARNING,
            {
                blankLine: 'always',
                prev: ['return', 'block', 'block-like', 'break', 'continue'],
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: ['return', 'block', 'block-like', 'break', 'continue'],
            },
            {
                blankLine: 'always',
                prev: ['const', 'let', 'var'],
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: ['const', 'let', 'var'],
            },
            {
                blankLine: 'any',
                prev: ['const', 'let', 'var'],
                next: ['const', 'let', 'var'],
            },
            {
                blankLine: 'any',
                prev: 'case',
                next: 'case',
            },
            {
                blankLine: 'always',
                prev: 'import',
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: 'import',
            },
            {
                blankLine: 'any',
                prev: 'import',
                next: 'import',
            },
        ],

        // order
        'import-helpers/order-imports': [
            ERROR,
            {
                newlinesBetween: 'always',
                // Массив ниже предопределяет группы, на которые должны быть разделены импорты.
                // Проверка происходит по принципу подхождения пути импорта под регулярное выражение.
                groups: [
                    // Сначала внешние модули
                    'module',
                    // Клиентский корневой импорт
                    '/prerequisites/',
                    // Константы. Лежат в подпапках или файлах constants
                    '/constants/',
                    // Типы и интерфейсы. Лежат в подпапках и файлах type или types
                    '/(/|^)types?(/|$)/',
                    '/^reducers/',
                    '/selectors/',
                    '/^sagas/',
                    // Вспомогательные функции. Лежат в подпапках и файлах lib|helpers|utilities|utils
                    '/(lib|helpers|utilities|utils)/',
                    // Переводы
                    '/^(i18nNew|i18n)/',
                    '/^(hooks)/',
                    '/^containers/',
                    // Компоненты. Лежат в попапках и файлах components|icons
                    '/(^icons|components)/',
                    '/^projects/',
                    '/^contexts/',
                    '/^server/',
                    '/^serviceProvider/',
                    // Картинки
                    '/^images/',
                    // Относительные пути
                    ['parent', 'sibling', 'index'],
                    // Пути до стилей
                    '/\\.scss$/',
                ],
            },
        ],

        // Отключаем prettier чтобы в процессе работы не было постоянной подсветки:
        // - форматирование должно быть на коммит
        // - проверка, что форматирование не пропустили в проверке на PR (prettier --check)
        "prettier/prettier": OFF,
    },

    overrides: [
        {
            files: ['*.ts'],
            parser: '@typescript-eslint/parser',
            parserOptions: {
                sourceType: 'module',
            },
            plugins: ['@typescript-eslint'],
            rules: {
                // For tsx, the react/sort-comp rule is used is client
                '@typescript-eslint/member-ordering': [
                    ERROR,
                    {
                        default: [
                            'public-static-field',
                            'protected-static-field',
                            'private-static-field',

                            'public-static-method',
                            'protected-static-method',
                            'private-static-method',

                            'public-instance-field',
                            'protected-instance-field',
                            'private-instance-field',

                            'constructor',

                            'public-instance-method',
                            'protected-instance-method',
                            'private-instance-method',
                        ],
                    },
                ],
            },
        },
        {
            files: ['*.ts', '*.tsx'],
            parser: '@typescript-eslint/parser',
            parserOptions: {
                sourceType: 'module',
            },
            plugins: ['@typescript-eslint'],
            rules: {
                // TypeScript compiler handles these on its own
                strict: OFF,
                'no-undef': OFF,
                'no-dupe-class-members': OFF,
                'valid-jsdoc': OFF,

                // TypeScript-specific extension rules
                'no-array-constructor': OFF,
                'no-duplicate-imports': OFF,
                'no-loop-func': OFF,
                'no-redeclare': OFF,
                'no-shadow': OFF,
                'no-unused-expressions': OFF,
                'no-unused-vars': OFF, // Disable because we use an analogue @typescript-eslint/no-unused-vars
                'no-use-before-define': OFF,
                'no-useless-constructor': OFF,
                '@typescript-eslint/no-array-constructor': WARNING,
                '@typescript-eslint/no-duplicate-imports': ERROR,
                '@typescript-eslint/no-loop-func': ERROR,
                '@typescript-eslint/no-redeclare': ERROR,
                '@typescript-eslint/no-shadow': WARNING,
                '@typescript-eslint/no-unused-expressions': ERROR,
                '@typescript-eslint/no-unused-vars': [
                    ERROR,
                    {
                        ignoreRestSiblings: true,
                        argsIgnorePattern: '^_',
                    },
                ],
                '@typescript-eslint/no-use-before-define': [
                    WARNING,
                    {functions: false},
                ],
                '@typescript-eslint/no-useless-constructor': ERROR,
                '@typescript-eslint/explicit-function-return-type': [
                    ERROR,
                    {
                        allowTypedFunctionExpressions: true,
                    },
                ],
                '@typescript-eslint/array-type': [
                    ERROR,
                    {
                        default: 'array',
                    },
                ],

                '@typescript-eslint/naming-convention': [
                    ERROR,
                    {
                        selector: 'interface',
                        format: ['PascalCase'],
                        prefix: ['I'],
                    },
                    {
                        selector: 'typeAlias',
                        format: ['PascalCase'],
                        prefix: ['T'],
                    },
                    {
                        selector: 'enum',
                        format: ['PascalCase'],
                        prefix: ['E'],
                    },
                    {
                        selector: 'enumMember',
                        format: ['UPPER_CASE'],
                    },
                ],
                '@typescript-eslint/member-delimiter-style': ERROR,
                '@typescript-eslint/explicit-member-accessibility': [
                    ERROR,
                    {accessibility: 'no-public'},
                ],
                '@typescript-eslint/consistent-type-assertions': ERROR,
                '@typescript-eslint/no-explicit-any': WARNING,
                '@typescript-eslint/no-namespace': ERROR,
                '@typescript-eslint/no-non-null-assertion': WARNING,
                '@typescript-eslint/no-parameter-properties': ERROR,
                '@typescript-eslint/triple-slash-reference': ERROR,
                '@typescript-eslint/prefer-namespace-keyword': ERROR,
                '@typescript-eslint/no-inferrable-types': [
                    ERROR,
                    {
                        ignoreParameters: true,
                        ignoreProperties: true,
                    },
                ],
                '@typescript-eslint/type-annotation-spacing': [
                    ERROR,
                    {
                        before: true,
                        after: true,
                        overrides: {
                            colon: {
                                before: false,
                            },
                        },
                    },
                ],
            },
        },
    ],
};
