const {OFF, WARNING, ERROR} = require('./constants');

module.exports = {
    extends: [
        'plugin:react/recommended',
        'plugin:react/jsx-runtime',
    ],
    plugins: ['react', 'react-hooks'],
    parserOptions: {
        sourceType: 'module',
        ecmaFeatures: {
            jsx: true,
        },
    },
    env: {
        browser: true,
    },
    rules: {
        'react/prop-types': WARNING,
        'react/sort-comp': WARNING,
        'react/jsx-curly-brace-presence': [WARNING, {props: 'never', children: 'never', propElementValues: 'always'}],

        'react-hooks/rules-of-hooks': ERROR,
        'react-hooks/exhaustive-deps': WARNING,
    },
    settings: {
        react: {
            version: 'detect',
        },
    },
    overrides: [
        {
            files: ['*.ts', '*.tsx'],
            rules: {
                'react/prop-types': OFF,
                'react/sort-comp': [
                    WARNING,
                    {
                        order: [
                            'static-methods',
                            'instance-variables',
                            'lifecycle',
                            'everything-else',
                            'render',
                        ],
                    },
                ],
            },
        },
    ],
};
