const _ = require('lodash');

const ICONS_RE = /^Icons\s*\/\s*(?<size>\d+)\s*\/\s*(?<name>.*)$/;

const config = {
    outputDirectory: 'dist',
    file: 'I8EBpOVkBHKTHVrDyWuaaIhI',
    node: '30:2',
    select({name}) {
        return ICONS_RE.test(name);
    },
    getFileName(component) {
        const matchResult = ICONS_RE.exec(component.name);
        const {size, name} = matchResult.groups;

        return `${size}/${name}.tsx`;
    },
    getComponentName(component) {
        const matchResult = ICONS_RE.exec(component.name);
        const {name} = matchResult.groups;

        return _.upperFirst(_.camelCase(name)) + 'Icon';
    },
    getSvgrConfig(component) {
        const matchResult = ICONS_RE.exec(component.name);
        const {size} = matchResult.groups;

        return {
            typescript: true,
            template: ({componentName, jsx}, {tpl}) => {
                return tpl`
          import * as React from 'react';
          ${'\n'}
          import {IIconProps} from 'icons/types/icon';
          ${'\n'}
          const ${componentName} = (props: IIconProps) => ${jsx};
          ${'\n'}
          ${componentName}.defaultProps = {
            width: ${size.toString()},
            height: ${size.toString()},
            fill: 'currentColor',
            focusable: 'false'
          };
          ${'\n'}
          export default ${componentName};
        `;
            },
            dimensions: false,
            replaceAttrValues: {'#333333': '{props.fill}'},
        };
    },
};

module.exports = config;
