import {camelCase, upperFirst} from 'lodash';
import * as fs from 'fs';

/**
 * Пример конфига для выгрузки растровых изображений проекта Travel
 */
/**
 * Поправьте путь до интерфейса
 * import { EExportMode, IFriggaOptions } from "@yandex-data-ui/frigga";
 */
import {EExportMode, IFriggaOptions} from '../src';

const RASTER_ILLUSTRATIONS_RE =
    /^RasterIllustration\s*\/\s*(?<name>[^\/\s]+)\s*\/\s*(?<size>.*)$/;

export const outputDirectory: IFriggaOptions['outputDirectory'] = 'dist';
export const file: IFriggaOptions['file'] = 'I8EBpOVkBHKTHVrDyWuaaIhI';

export const select: IFriggaOptions['select'] = ({name}) => {
    return RASTER_ILLUSTRATIONS_RE.test(name);
};

export const getFileName: IFriggaOptions['getFileName'] = component => {
    const matchResult = RASTER_ILLUSTRATIONS_RE.exec(component.name);

    if (!matchResult || !matchResult.groups) {
        throw new Error('Unexpected component name');
    }

    const {size, name} = matchResult.groups;

    return `${size}/${name}.tsx`;
};

export const getComponentName: IFriggaOptions['getComponentName'] =
    component => {
        const matchResult = RASTER_ILLUSTRATIONS_RE.exec(component.name);

        if (!matchResult || !matchResult.groups) {
            throw new Error('Unexpected component name');
        }

        const {name} = matchResult.groups;

        return upperFirst(camelCase(name)) + 'Image';
    };

export const exportMode: IFriggaOptions['exportMode'] = EExportMode.PNG;

export const exportScale: IFriggaOptions['exportScale'] = 2;

export const exportPngTemplate: IFriggaOptions['exportPngTemplate'] =
    fs.readFileSync('examples/png-template.tsx', 'utf8');
