import {camelCase, upperFirst} from 'lodash';

/**
 * Поправьте путь до интерфейса
 * import { IFriggaOptions } from "@yandex-data-ui/frigga";
 */
import {IFriggaOptions} from '../src';

const ICONS_RE = /^Icons\s*\/\s*(?<size>\d+)\s*\/\s*(?<name>.*)$/;

export const outputDirectory: IFriggaOptions['outputDirectory'] = 'dist';
export const file: IFriggaOptions['file'] = 'I8EBpOVkBHKTHVrDyWuaaIhI';

export const select: IFriggaOptions['select'] = ({name}) => {
    return ICONS_RE.test(name);
};

export const getFileName: IFriggaOptions['getFileName'] = component => {
    const matchResult = ICONS_RE.exec(component.name);

    if (!matchResult || !matchResult.groups) {
        throw new Error('Unexpected component name');
    }

    const {size, name} = matchResult.groups;

    return `${size}/${name}.tsx`;
};

export const getComponentName: IFriggaOptions['getComponentName'] =
    component => {
        const matchResult = ICONS_RE.exec(component.name);

        if (!matchResult || !matchResult.groups) {
            throw new Error('Unexpected component name');
        }

        const {name} = matchResult.groups;

        return upperFirst(camelCase(name)) + 'Icon';
    };

export const getSvgrConfig: NonNullable<
    IFriggaOptions['getSvgrConfig']
> = component => {
    const matchResult = ICONS_RE.exec(component.name);

    if (!matchResult || !matchResult.groups) {
        throw new Error('Unexpected component name');
    }

    const {size} = matchResult.groups;

    return {
        typescript: true,
        template: ({componentName, jsx}, {tpl}) => {
            return tpl`
          import * as React from 'react';
          ${'\n'}
          import {IIconProps} from 'icons/types/icon';
          ${'\n'}
          const ${componentName} = (props: IIconProps) => ${jsx};
          ${'\n'}
          ${componentName}.defaultProps = {
            width: ${size.toString()},
            height: ${size.toString()},
            fill: 'currentColor',
            focusable: 'false'
          };
          ${'\n'}
          export default ${componentName};
        `;
        },
        dimensions: false,
        replaceAttrValues: {'#333333': '{props.fill}'},
    };
};
