import {Box, Text} from 'ink';
import React from 'react';

import ECLIState from '../../types/ECLIState';

import getCliLabelByState from './utilities/getCliLabelByState';

import Summary from './components/Summary/Summary';
import FailedComponentList from './components/FailedComponentList/FailedComponentList';
import Progress from './components/Progress/Progress';

import useCliState from '../../hooks/useCliState';

const CliView: React.FC = () => {
    const {state, components} = useCliState();

    return (
        <Box flexDirection="column">
            <Box marginBottom={1} flexDirection="column">
                <Text bold color="green">
                    {getCliLabelByState(state)}
                </Text>
            </Box>
            <Box flexDirection="column">
                <Progress state={state} components={components} />
                {state === ECLIState.FINISHED && (
                    <>
                        <FailedComponentList components={components} />
                        <Summary components={components} />
                    </>
                )}
            </Box>
        </Box>
    );
};

export default CliView;
