import React from 'react';
import {Box, Text} from 'ink';

import IComponentWithState from '../../../../types/IComponentWithState';

import isFailedComponent from './utilities/isFailedComponent';

import FailedComponent from './components/FailedComponent/FailedComponent';

interface IFailedComponentListProps {
    components: Readonly<IComponentWithState[]>;
}

const FailedComponentList: React.FC<IFailedComponentListProps> = ({
    components,
}) => {
    const failedComponents = components.filter(isFailedComponent);

    if (!failedComponents.length) {
        return null;
    }

    return (
        <Box flexDirection="column">
            <Text color="red">Failed components</Text>
            <Box flexDirection="column" paddingLeft={4}>
                {failedComponents.map(component => {
                    return (
                        <FailedComponent
                            key={component.name}
                            component={component}
                        />
                    );
                })}
            </Box>
        </Box>
    );
};

export default FailedComponentList;
