import React from 'react';
import {Box, Text} from 'ink';

import IComponentWithState from '../../../../../../types/IComponentWithState';

interface IFailedComponentProps {
    component: IComponentWithState;
}

const FailedComponent: React.FC<IFailedComponentProps> = ({component}) => {
    const {name, error} = component;

    return (
        <Box flexDirection="column" flexShrink={0}>
            <Box flexDirection="column" marginLeft={1} marginBottom={1}>
                <Box>
                    <Text>{name}</Text>
                </Box>
                {error && (
                    <Box>
                        <Text color="red">Error: </Text>
                        <Text>{error.message}</Text>
                    </Box>
                )}
            </Box>
        </Box>
    );
};

export default FailedComponent;
