import React, {useMemo} from 'react';
import {Box, Text} from 'ink';

import ECLIState from '../../../../types/ECLIState';
import EComponentState from '../../../../types/EComponentState';
import IComponentWithState from '../../../../types/IComponentWithState';

interface IProgressProps {
    state: ECLIState;
    components: IComponentWithState[];
}

const Progress: React.FC<IProgressProps> = ({state, components}) => {
    const processed = useMemo(() => {
        switch (state) {
            case ECLIState.IDLE:
            case ECLIState.LOADING:
            case ECLIState.FILTERING:
            case ECLIState.PROCESSING_META:
            case ECLIState.FINISHED:
                return 0;

            case ECLIState.RENDERING:
                return components.filter(
                    component => component.state === EComponentState.RENDERED,
                ).length;
            case ECLIState.PROCESSING:
                return components.filter(
                    component => component.state === EComponentState.FINISHED,
                ).length;
        }
    }, [state, components]);

    const total = useMemo(() => {
        switch (state) {
            case ECLIState.IDLE:
            case ECLIState.LOADING:
            case ECLIState.FILTERING:
            case ECLIState.FINISHED:
                return components.length;
            case ECLIState.RENDERING:
            case ECLIState.PROCESSING:
            case ECLIState.PROCESSING_META:
                return components.filter(
                    component => component.state !== EComponentState.UP_TO_DATE,
                ).length;
        }
    }, [state, components]);

    if (!total || !processed) {
        return null;
    }

    return (
        <Box>
            <Text bold>Progress: </Text>
            <Text>{`${processed} / ${total}`}</Text>
        </Box>
    );
};

export default Progress;
