import React from 'react';
import {Box, Text} from 'ink';

import IComponentWithState from '../../../../types/IComponentWithState';

import getComponentsSummary from './utilities/getComponentsSummary';

interface ISummaryProps {
    components: IComponentWithState[];
}

const Summary: React.FC<ISummaryProps> = ({components}) => {
    const {failedCount, finishedCount, upToDateCount, totalCount} =
        getComponentsSummary(components);

    return (
        <Box flexDirection="column">
            <Text>Summary:</Text>
            <Box flexDirection="column" paddingLeft={4}>
                {Boolean(finishedCount) && (
                    <Text color="green">Updated: {finishedCount}</Text>
                )}
                {Boolean(upToDateCount) && (
                    <Text color="yellow">Up to date: {upToDateCount}</Text>
                )}
                {Boolean(failedCount) && (
                    <Text color="red">Failed: {failedCount}</Text>
                )}
                <Text color="greenBright">Total: {totalCount}</Text>
                {totalCount === 0 && (
                    <Text color="red">
                        Components not found. Check «select» function from
                        config. Check publishing in Figma.
                    </Text>
                )}
            </Box>
        </Box>
    );
};

export default Summary;
