import IComponentWithState from '../../../../../types/IComponentWithState';
import EComponentState from '../../../../../types/EComponentState';

interface IComponentsSummary {
    upToDateCount: number;
    finishedCount: number;
    failedCount: number;
    totalCount: number;
}

export default function getComponentsSummary(
    components: IComponentWithState[],
): IComponentsSummary {
    const upToDateCount = components.filter(
        component => component.state === EComponentState.UP_TO_DATE,
    ).length;
    const finishedCount = components.filter(
        component => component.state === EComponentState.FINISHED,
    ).length;
    const failedCount = components.filter(
        component => component.state === EComponentState.FAILED,
    ).length;
    const totalCount = upToDateCount + finishedCount + failedCount;

    return {
        upToDateCount,
        finishedCount,
        failedCount,
        totalCount,
    };
}
