import ECLIState from '../../../types/ECLIState';

export default function getCliLabelByState(state: ECLIState): string {
    switch (state) {
        case ECLIState.IDLE:
            return 'Starting ...';
        case ECLIState.LOADING:
            return 'Loading files ...';
        case ECLIState.RENDERING:
            return 'Rendering components ...';
        case ECLIState.FILTERING:
            return 'Filtering components ...';
        case ECLIState.PROCESSING:
            return 'Processing components ...';
        case ECLIState.PROCESSING_META:
            return 'Processing meta ...';
        case ECLIState.FINISHED:
            return 'Finished';
    }
}
