import {useEffect, useReducer} from 'react';

import IAppState from '../types/IAppState';

import initialState from '../state/initialState';
import reducer from '../state/reducer';
import createAction from '../state/actions';
import {EVENT_TYPES, subscribe} from '../../eventEmitter';

export default function useCliState(): IAppState {
    const [state, dispatch] = useReducer(reducer, initialState);

    useEffect(() => {
        const unsubscribes = EVENT_TYPES.map(eventType => {
            return subscribe(eventType, (data = null) => {
                return dispatch(createAction(eventType, data));
            });
        });

        return (): void => {
            unsubscribes.forEach(fn => fn());
        };
    }, []);

    return state;
}
