import {TData} from '../../eventEmitter/types/TDataType';

import {EEventType} from '../../eventEmitter';

interface IAction<T extends EEventType> {
    type: T;
    payload: TData<T>;
}

type TActionTypeMap = {[T in EEventType]: IAction<T>};

export type TActions = TActionTypeMap[EEventType];

export default function createAction<T extends EEventType>(
    type: T,
    payload: TData<T>,
): TActions {
    return {
        type,
        payload,
    } as TActions;
}
