import {produce} from 'immer';

import IAppState from '../types/IAppState';
import EComponentState from '../types/EComponentState';
import ECLIState from '../types/ECLIState';

import {TActions} from './actions';
import {EEventType} from '../../eventEmitter';

export default produce((state: IAppState, action: TActions) => {
    switch (action.type) {
        case EEventType.FILE_COMPONENTS_REQUEST: {
            state.state = ECLIState.LOADING;

            return;
        }
        case EEventType.FILE_COMPONENTS_SUCCESS: {
            action.payload.forEach(({name}) => {
                state.components.push({
                    name,
                    state: EComponentState.LOADING,
                });
            });

            return;
        }
        case EEventType.FILTER_COMPONENTS_REQUEST: {
            state.state = ECLIState.FILTERING;

            return;
        }
        case EEventType.RENDER_COMPONENTS_REQUEST: {
            state.state = ECLIState.RENDERING;

            return;
        }
        case EEventType.PROCESS_COMPONENTS_REQUEST: {
            state.state = ECLIState.PROCESSING;

            return;
        }
        case EEventType.PROCESS_META_REQUEST: {
            state.state = ECLIState.PROCESSING_META;

            return;
        }
        case EEventType.PROCESS_META_SUCCESS: {
            state.state = ECLIState.FINISHED;

            return;
        }
        case EEventType.COMPONENT_IS_UP_TO_DATE: {
            const {name} = action.payload;

            setComponentState(state, name, EComponentState.UP_TO_DATE);

            return;
        }
        case EEventType.PROCESS_COMPONENT_REQUEST: {
            const {name} = action.payload;

            setComponentState(state, name, EComponentState.PROCESSING);

            return;
        }
        case EEventType.RENDER_COMPONENT_REQUEST: {
            const {name} = action.payload;

            setComponentState(state, name, EComponentState.RENDERING);

            return;
        }
        case EEventType.RENDER_COMPONENT_SUCCESS: {
            const {name} = action.payload;

            setComponentState(state, name, EComponentState.RENDERED);

            return;
        }
        case EEventType.PROCESS_COMPONENT_SUCCESS: {
            const {name} = action.payload;

            setComponentState(state, name, EComponentState.FINISHED);

            return;
        }

        case EEventType.PROCESS_COMPONENT_FAILED: {
            const {
                error,
                icon: {name},
            } = action.payload;

            setComponentState(state, name, EComponentState.FAILED, error);

            return;
        }
    }
});

function setComponentState(
    state: IAppState,
    name: string,
    componentState: EComponentState,
    error?: Error,
): void {
    const component = state.components.find(c => c.name === name);

    if (component) {
        component.state = componentState;
        component.error = error;
    }
}
