import fs from 'fs';
import path from 'path';
import yargs from 'yargs';

import IFriggaOptions from '../types/IFriggaOptions';

require('typescript-require')({
    tmpDir: path.resolve(__dirname, 'tmp'),
});

export async function resolveConfig(): Promise<IFriggaOptions> {
    const configArg = await yargs.option('config', {
        alias: 'c',
        describe: '<path> Frigga config file path',
        default: path.join(process.cwd(), 'frigga.config.js'),
        requiresArg: true,
        type: 'string',
    }).argv;
    const configPath = path.resolve(configArg.config);

    if (!fs.existsSync(configPath)) {
        throw new Error(
            `Config file not exist. Change config path via CLI param --config, -c. Current config path: ${configPath}`,
        );
    }

    return require(configPath);
}
