import path from 'path';
import fse from 'fs-extra';

import IFriggaOptions from '../../types/IFriggaOptions';
import {TMetaFileFormat} from '../../types/TMetaFileFormat';

export default class MetaFileProvider {
    private readonly metaPath: string;
    private readonly noCache: boolean;

    constructor({
        outputDirectory,
        noCache,
    }: Pick<IFriggaOptions, 'outputDirectory' | 'noCache'>) {
        this.metaPath = path.join(outputDirectory, 'meta.json');
        this.noCache = noCache;
    }

    async read(): Promise<TMetaFileFormat> {
        if (this.noCache) {
            return {};
        }

        if (await fse.pathExists(this.metaPath)) {
            return fse.readJSON(this.metaPath);
        }

        return {};
    }

    async save(meta: TMetaFileFormat): Promise<void> {
        return fse.outputJson(this.metaPath, meta, {spaces: 4});
    }
}
