import {FullComponentMetadata} from 'figma-js';

import {TMetaFileFormat} from '../../types/TMetaFileFormat';

export default function collectMeta(
    components: FullComponentMetadata[],
): TMetaFileFormat {
    return components.reduce((acc, component) => {
        return {
            ...acc,
            [component.key]: {
                icon: {
                    name: component.name,
                    key: component.key,
                },
                createdAt: component.created_at,
                updatedAt: component.updated_at,
            },
        };
    }, {});
}
