import IFriggaOptions from '../../../types/IFriggaOptions';
import EExportMode from '../../../types/EExportMode';

export default function createGetFileName(
    exportMode: EExportMode,
): IFriggaOptions['getFileName'] {
    const getFileName: IFriggaOptions['getFileName'] = icon => {
        const nameWithoutSpace = icon.name.replace(/\s/g, '');

        switch (exportMode) {
            case EExportMode.SVG:
                return `${nameWithoutSpace}.svg`;
            case EExportMode.REACT_COMPONENT:
            default:
                return `${nameWithoutSpace}.js`;
        }
    };

    return getFileName;
}
