import {upperFirst} from 'lodash';

import IFriggaOptions from '../../../types/IFriggaOptions';

const getComponentName: NonNullable<
    IFriggaOptions['getComponentName']
> = icon => {
    return upperFirst(
        icon.name.replace(/[^0-9a-zA-Z_]/g, '').replace(/^[^a-zA-Z_]+/, ''),
    );
};

export default getComponentName;
