import {FullComponentMetadata} from 'figma-js';

import {TMetaFileFormat} from '../../../types/TMetaFileFormat';

import isComponentChanged from './utilities/isComponentChanged';

import {EEventType, emit} from '../../../eventEmitter';

export default function filterComponentsWithChanges(
    components: FullComponentMetadata[],
    meta: TMetaFileFormat,
): FullComponentMetadata[] {
    return components.filter(component => {
        if (isComponentChanged(component, meta)) {
            return true;
        }

        emit(EEventType.COMPONENT_IS_UP_TO_DATE, component);

        return false;
    });
}
