import {FullComponentMetadata} from 'figma-js';

import {TMetaFileFormat} from '../../../../types/TMetaFileFormat';

export default function isComponentChanged(
    component: FullComponentMetadata,
    meta: TMetaFileFormat,
): boolean {
    const prevMeta = meta[component.key];

    if (!prevMeta) {
        return true;
    }

    return prevMeta.updatedAt !== component.updated_at;
}
