import {FileImageParams} from 'figma-js';

import EExportMode from '../../types/EExportMode';

export default function getFigmaFormatByExportMode(
    exportMode: EExportMode,
): FileImageParams['format'] {
    switch (exportMode) {
        case EExportMode.SVG:
        case EExportMode.REACT_COMPONENT:
            return 'svg';
        case EExportMode.PNG:
            return 'png';
    }
}
