import IComponentNode from '../../../../../types/IComponentNode';
import IFriggaOptions from '../../../../../types/IFriggaOptions';
import EExportMode from '../../../../../types/EExportMode';

import createReactIcon from './createReactIcon';
import createSvgIcon from './createSvgIcon';
import createImageComponent from './createImageComponent';

export default async function convertComponent(
    source: string,
    icon: IComponentNode,
    {
        getComponentName,
        getSvgrConfig,
        getSvgoConfig,
        exportMode,
        exportPngTemplate,
    }: Required<
        Pick<
            IFriggaOptions,
            | 'getComponentName'
            | 'getSvgrConfig'
            | 'getSvgoConfig'
            | 'exportMode'
        >
    > &
        Pick<IFriggaOptions, 'exportPngTemplate'>,
): Promise<string> {
    switch (exportMode) {
        case EExportMode.REACT_COMPONENT:
            return createReactIcon(
                source,
                getComponentName(icon),
                getSvgrConfig(icon),
            );
        case EExportMode.SVG:
            return createSvgIcon(source, getSvgoConfig(icon));
        case EExportMode.PNG: {
            return createImageComponent(
                source,
                getComponentName(icon),
                exportPngTemplate,
            );
        }
    }
}
