import EExportMode from '../../../../../types/EExportMode';

export default function createImageComponent(
    pngFileName: string,
    componentName: string,
    exportPngTemplate: string | undefined,
): string {
    if (!exportPngTemplate) {
        throw new Error(
            `For exportMode === ${EExportMode.PNG} option "exportPngTemplate" required`,
        );
    }

    return exportPngTemplate
        .replace(new RegExp('IMAGE_COMPONENT_NAME', 'g'), componentName)
        .replace(new RegExp('IMAGE_PATH', 'g'), `./${pngFileName}`);
}
