import {Config, transform} from '@svgr/core';

export default function createReactIcon(
    svgCode: string,
    componentName: string,
    config: Config = {},
): Promise<string> {
    const svgrConfig = {...getDefaultSVGRConfig(), ...config};

    return transform(svgCode, svgrConfig, {componentName});
}

function getDefaultSVGRConfig(): Config {
    return {
        plugins: [
            '@svgr/plugin-svgo',
            '@svgr/plugin-jsx',
            '@svgr/plugin-prettier',
        ],
        svgo: true,
    };
}
