import {optimize, OptimizeOptions} from 'svgo';

export default function createSvgIcon(
    svgString: string,
    svgoConfig: OptimizeOptions,
): string {
    const optimizedSvg = optimize(svgString, svgoConfig);

    if ('data' in optimizedSvg) {
        return optimizedSvg.data;
    }

    throw optimizedSvg.modernError;
}
