import {AxiosInstance, AxiosStatic} from 'axios';
import axiosRetry, {
    exponentialDelay,
    isNetworkError,
    isRetryableError,
} from 'axios-retry';

export default function setAxiosRetry(
    axiosInstance: AxiosInstance | AxiosStatic,
): void {
    axiosRetry(axiosInstance, {
        retryCondition: (error): boolean =>
            isNetworkError(error) || isRetryableError(error),
        retryDelay: exponentialDelay,
        retries: 2,
    });
}
