import EventEmitter from 'events';

import {EEventType} from './types/EEventType';
import type {TData} from './types/TDataType';
import type {TListenerFunction} from './types/TListenerFunction';
import type {TEventTypeWithData} from './types/TEventTypeWithData';

const eventEmitter = new EventEmitter();

export function emit<T extends TEventTypeWithData>(
    eventName: T,
    data: TData<T>,
): boolean;
export function emit<T extends Exclude<EEventType, TEventTypeWithData>>(
    eventName: T,
): boolean;

export function emit<T extends EEventType>(
    eventName: T,
    data?: TData<T>,
): boolean {
    return eventEmitter.emit(eventName, data);
}

export function subscribe<T extends EEventType>(
    event: T,
    listener: TListenerFunction<T>,
): () => void {
    eventEmitter.on(event, listener);

    return (): void => {
        eventEmitter.off(event, listener);
    };
}
