export enum EEventType {
    /**
     * 1 Step: Get components from file via Figma api
     */
    FILE_COMPONENTS_REQUEST = 'FILE_COMPONENTS_REQUEST',
    FILE_COMPONENTS_SUCCESS = 'FILE_COMPONENTS_SUCCESS',

    /**
     * 2 Step: Filter components by meta
     */
    FILTER_COMPONENTS_REQUEST = 'FILTER_COMPONENTS_REQUEST',
    FILTER_COMPONENTS_SUCCESS = 'FILTER_COMPONENTS_SUCCESS',

    /**
     * 3 Step: Render components stt
     */
    RENDER_COMPONENTS_REQUEST = 'RENDER_COMPONENTS_REQUEST',
    RENDER_COMPONENTS_SUCCESS = 'RENDER_COMPONENTS_SUCCESS',

    /**
     * 4 Step: Process components step
     */
    PROCESS_COMPONENTS_REQUEST = 'PROCESS_COMPONENTS_REQUEST',
    PROCESS_COMPONENTS_SUCCESS = 'PROCESS_COMPONENTS_SUCCESS',

    /**
     * 5 Step: Collect and save metadata
     */
    PROCESS_META_REQUEST = 'PROCESS_META_REQUEST',
    PROCESS_META_SUCCESS = 'PROCESS_META_SUCCESS',

    /**
     * Component is up to date
     */
    COMPONENT_IS_UP_TO_DATE = 'COMPONENT_IS_UP_TO_DATE',

    /**
     * Render images for component by Figma api
     */
    RENDER_COMPONENT_REQUEST = 'RENDER_COMPONENT_REQUEST',
    RENDER_COMPONENT_SUCCESS = 'RENDER_COMPONENT_SUCCESS',

    /**
     * Process: download image, convert and save to file component
     */
    PROCESS_COMPONENT_REQUEST = 'PROCESS_COMPONENT_REQUEST',
    PROCESS_COMPONENT_SUCCESS = 'PROCESS_COMPONENT_SUCCESS',
    PROCESS_COMPONENT_FAILED = 'PROCESS_COMPONENT_FAILED',
}

export const EVENT_TYPES = Object.values(EEventType);
